/* Wiktor Zychla, 2003 */
using System;
using System.Drawing;
using System.Windows.Forms;

namespace Example
{
  public class CKomponent : UserControl
  {
    public CKomponent() {}

    protected override void OnPaint( PaintEventArgs e )
    {
      StringFormat sf  = new StringFormat();
      sf.Alignment     = StringAlignment.Center;
      sf.LineAlignment = StringAlignment.Center;

      e.Graphics.Clear( this.BackColor );
      e.Graphics.DrawString( this.Text, this.Font, Brushes.Black, 
                             this.Width / 2, this.Height / 2, sf );
    }

    protected override void OnResize( EventArgs e )
    {
      Invalidate();
    }
  }

  public class CMainForm : Form
  {  
    CKomponent ck1, ck2;

    public CMainForm() 
    {
      ck1      = new CKomponent();
      ck1.Text = "Komponent 1";
      ck1.BackColor = Color.Red;
      ck1.Font = new Font( "Tahoma", 18 );
      ck1.Size = new Size( 50, 50 );
      ck1.Dock = DockStyle.Fill;

      ck2      = new CKomponent();
      ck2.Text = "Komponent 2";
      ck2.Font = new Font( "Courier", 32 );
      ck2.Dock = DockStyle.Top;

      this.Controls.AddRange( new Control[] { ck1, ck2 } );
    }

    public static void Main()
    {    
      Application.Run( new CMainForm() );
    }
  }
}

